// size
local progress_width = ScrW() * 0.5;
local progress_height = 128;

// spawnmenu
ProgressWindow	= AppFramework:NewApplication( "VMF-Suite, Progres Window" );
ProgressWindow:SetPos( progress_width * 0.5, ScrH() + 8 );
ProgressWindow:SetSize( progress_width, progress_height );
ProgressWindow:SetAttrb( false, false, false, false, false );
ProgressWindow:Show();

// events
ProgressWindow:AddEvent( "OnThink", "OnThink" );


// think
function ProgressWindow:OnThink( )
	// creep towards idealy.
	local speed = FrameTime() * self.Speed;
	local dist = self.IdealY - self.CurrentY;

	// apply velocity
	self.CurrentY = self.CurrentY + self.VelocityY * speed;
	
	// add to velocity.
	self.VelocityY = self.VelocityY + dist * speed;
	if( math.abs( self.VelocityY ) <= 0.5 ) then
		self.VelocityY = 0;
	
	end
	
	// degrade velocity.
	self.VelocityY = self.VelocityY * ( 0.85 - FrameTime() * 8 );
	
	// update pos.
	self:SetPos( progress_width * 0.5, self.CurrentY );
	
	// hide if our currenty is under the screen and our idealy is there too.
	if( self.CurrentY > ScrH() && self.IdealY > ScrH() && self:IsVisible() ) then
		self:Hide();
		print( "hiding" );
		
	end
	
end



// set progress.
function ProgressWindow:SetProgress( v )
	self.progressbar:SetValue( v );

end

function ProgressWindow:IncrementProgress( )
	self.progressbar:SetValue( self.progressbar:GetValue() + 1 );

end

// clear progress
function ProgressWindow:InitProgressBar( mins, maxs )
	self.progressbar:SetRange( mins, maxs );
	self.progressbar:SetValue( mins );	

end

// set status
function ProgressWindow:SetStatus( text )
	self.header:SetTitle( text );
	self.header:GetHandle():InvalidateLayout();

end

// hide progress bar
function ProgressWindow:ShowProgressDisplay( )
	self.IdealY = ScrH() - 48;
	self.Speed = 16;
	self:Show();

end

// hide progress bar
function ProgressWindow:HideProgressDisplay( )
	self.IdealY = ScrH() + 8;
	self.Speed = 8;

end



// init
function ProgressWindow:Init( )
	// animoot.
	self.CurrentY = ScrH() + 8;
	self.IdealY = ScrH() + 8;
	self.VelocityY = 0;
	self.Speed = 2;

end

// init controls.
function ProgressWindow:CreateControls( )
	// create a header control.
	local header = CtlHeader_class:create( self:GetHandle() );
	header:SetPos( 0, 0 );
	header:SetSize( progress_width, progress_height );
	header:SetTitle( "" );
	
	// create a progress bar.
	local progress1 = CtlProgressBar_class:create( header:GetHandle() );
	progress1:SetPos( 8, 22 );
	progress1:SetSize( progress_width - 16, 24 );
	progress1:SetRange( 1, 100 );
	progress1:SetValue( 50 );
	progress1:SetAttrb( false, false, true );
	
	// store
	self.progressbar = progress1;
	self.header = header;
	
end

// create
ProgressWindow:CreateControls();
ProgressWindow:Init();

